
#ifndef _1_MNG_ATP_TST_SPECIFIC_LCS_h_H
#define _1_MNG_ATP_TST_SPECIFIC_LCS_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"
#include "MNG_ATP_TST_Defines.h"
#include "CRYS_AES.h"
#include "CRYS_HASH.h"
#include "MNG_Functions.h"


#ifdef __cplusplus
extern "C"
{
#endif


  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Jul 31 10:18:14 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MNG_ATP_TST_Specific_LCS.h#1:incl:1
   *  \author NogaD
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines *******************************/
/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/

/* Data struct for RSA test functions */
typedef struct TST_MNG_RSAKey_TestDataStruct{	
	DxChar					  TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t                 TST_N[TST_MNG_MAX_DATA_SIZE];
	DxUint32_t                TST_NLen;
    DxUint8_t                 TST_E[TST_MNG_MAX_DATA_SIZE];
    DxUint16_t				  TST_ELen;
    DxUint8_t                 TST_D[TST_MNG_MAX_DATA_SIZE];
	DxUint8_t                 TST_Data[TST_MNG_MAX_DATA_SIZE];
	DxUint8_t                 TST_Output[TST_MNG_MAX_DATA_SIZE];
	DxUint8_t                 TST_ExpectedOutput[TST_MNG_MAX_DATA_SIZE];
} TST_MNG_RSAKey_TestDataStruct;


/* Data struct for MonCounter test function */
typedef struct TST_MNG_HASH_TestDataStruct{	
    DxChar					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t 					TST_input_data[TST_MNG_MAX_DATA_SIZE];
	DxUint16_t					TST_input_dataSize;
	CRYS_HASH_Result_t       	TST_HashResultBuff;
	DxUint8_t 					TST_SHA1_Expected_output_data[CRYS_HASH_SHA1_DIGEST_SIZE_IN_BYTES];
	DxUint16_t					TST_SHA1_Expected_dataSize;		
	CRYS_HASH_OperationMode_t	TST_OperationMode;
} TST_MNG_HASH_TestDataStruct;

/*****************************************************************************
 * Function Name:                                                           
 *  MNG_ATP_TST_Set_LCS_To_Spec_Secure_State      
 *  
 * Inputs:
 *  None
 *
 * Outputs: 
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is an Acceptance test for MNG APIs. 
 *  
 * Algorithm:       
 * 1. Get the current life cycle state, and verify it by calling DX_MNG_GetLCS
 *    API
 * 2. Set the RKEK with a known value by calling DX_MNG_SetRkekOtp API
 * 3. Set the OEM public key - to constant value by calling 
 *    DX_MNG_SetOemRsaPubKeyHashOtp API
 * 4. Change the LCS to the specific required LCS (through Device_manufacture 
 *    and secure states) by calling DX_MNG_ChangeLCS
 * 5. Verify legal operations on current state:
 *	  a. CRYS AES operation - Do AES Encrypt on data and verify the output is
 *       as expected
 *    b. CRYS HASH operation - Do HASH on data and verify that the output is 
 *       as expected
 *    c. CRYS RSA operation - Do RSA_PRIM_Encrypt and verify that the output
 *       is as expected 
 * 6. Verify illegal operations on current state
 *	  a. SST Operation - do SST get version and verify it fails
 *    b. SST Operation - do SST Init and verify it fails
 *    c. KMNG operation - do KMNG Init and verify that it fails
 *
 ******************************************************************************/
 
DxError_t MNG_ATP_TST_Set_LCS_To_Spec_Secure_State( void );


#ifdef __cplusplus
}
#endif

#endif
